; *** Einstellungen fr MauWi (Mac-OS-X-Update fr Windows)    ***
; *** Autor: Andreas Ltteken (andreas.luetteken[at]libero.it) ***

#include <GUIConstants.au3>

Dim $SetProxyName, $SetProxyUser, $SetPrxyPort, $SetVolName, $msg, $FHandle
Dim	$UserVal,$PortVal, $ProxyVal, $Proxy, $FolderVal
Dim $btn_Cancel, $btn_Save, $result, $settings
Dim $posxl, $posxf, $posy

; Position des ersten GUI-Elements setzen
$posy=20
$posxf=120
$posxl=20

; Einstellungen aus der Datei ".\static\settings" auslesen
$settings = ".\static\settings"
; Einstellungsdatei nur lesend ffnen
$FHandle= FileOpen($settings,0)
	If $FHandle <> -1 then
		; 
		$FolderVal = FileReadLine($FHandle,2)		
		$UserVal = FileReadLine($FHandle,4)
		$ProxyVal = FileReadLine($FHandle,5)
		$PortVal = FileReadLine($FHandle,6)
		FileClose($FHandle)
	Else
		; noch keine Einstellungen vorhanden, Standardwerte setzen
		$UserVal = ""
		$ProxyVal = "[Proxy-Server]"
		$PortVal = 8080
	EndIf
	
If $FolderVal = "" then $FolderVal = "[Volume-Name]"

; Fenster mit Bedienelementen anlegen

$maindlg = GUICreate("Einstellungen", 300, 195, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE - $WS_SIZEBOX - $WS_MAXIMIZEBOX)
GUISetFont(9, 400, 0, "Sans Serif")

GUICtrlCreateLabel("Proxy-Server:", $posxl, $posy+2, 80, 30)
$SetProxyName = GUICtrlCreateInput($ProxyVal,$posxf,$posy,160,20)
GUICtrlSetState($SetProxyName, $GUI_FOCUS) 
$posy=$posy+30

GUICtrlCreateLabel("Port:", $posxl, $posy+2, 80, 30)
$SetPrxyPort = GUICtrlCreateInput($PortVal,$posxf,$posy,40,20,$ES_NUMBER)
$posy=$posy+30

GUICtrlCreateLabel("Benutzer:", $posxl, $posy+2, 80, 30)
$SetProxyUser = GUICtrlCreateInput($UserVal,$posxf,$posy,160,20)
$posy=$posy+30

GUICtrlCreateLabel("Volume-Name:", $posxl, $posy+2, 80, 30)
$SetVolName = GUICtrlCreateInput($FolderVal,$posxf,$posy,160,20)
$posy=$posy+40

$btn_Save = GUICtrlCreateButton ("Speichern",30, $posy, 80, 30)
GUICtrlSetState($btn_Save, $GUI_DEFBUTTON) 

$btn_Cancel = GUICtrlCreateButton ("Abbrechen",190, $posy, 80, 30)

; Fenster anzeigen
GUISetState()

While 1
	; Was hat der Benutzer angeklickt?
	$msg = GUIGetMsg(0)

	Select
		Case $msg = $GUI_EVENT_CLOSE
			; Einstellungsprogramm ohne Speichern verlassen, wenn der Anwender das Fenster schliet
			ExitLoop
		Case $msg = $btn_Save
			; Werte abspeichern
			$FHandle= FileOpen($settings,2)
			If $FHandle <> -1 Then
				FileWriteLine($FHandle,"[Volume Name]")            ; Zeile 1  (Bereichsberschrift)
				FileWriteLine($FHandle,GUICtrlRead($SetVolName))   ; Zeile 2  (Name, den der Mac-Finder fr das Volume anzeigt)
				FileWriteLine($FHandle,"[Proxy Settings]")         ; Zeile 3  (Bereichsberschrift)
				FileWriteLine($FHandle,GUICtrlRead($SetProxyUser)) ; Zeile 4  (Benutzername fr Proxy-Server)
				FileWriteLine($FHandle,GUICtrlRead($SetProxyName)) ; Zeile 5  (Adresse des Proxy-Server)
				FileWriteLine($FHandle,GUICtrlRead($SetPrxyPort))  ; Zeile 6  (Port des Proxy-Server)
				FileWriteLine($FHandle,"[Platform Settings]")      ; Zeile 7  (Bereichsberschrift)
				FileWriteLine($FHandle,"[Intel]")                  ; Zeile 8  (Bereichsberschrift)
				FileWriteLine($FHandle,"1")                        ; Zeile 9  (Option "PowerPC-Prozessoren"; 0=nein, 1=ja)
				FileWriteLine($FHandle,"[PPC]")                    ; Zeile 10 (Bereichsberschrift)
				FileWriteLine($FHandle,"1")                        ; Zeile 11 (Option "Intel-Prozessoren"; 0=nein, 1=ja)
				FileWriteLine($FHandle,"[ISO]")                    ; Zeile 12 (Bereichsberschrift)
				FileWriteLine($FHandle,"0")                        ; Zeile 13 (Option "ISO-Datei zum Brennen einer DVD erstellen"; 0=nein, 1=ja)

				FileClose($FHandle)
			EndIf
			ExitLoop    
		Case $msg = $btn_Cancel
			; Einstellungsprogramm ohne Speichern verlassen, wenn der Anwender auf "Abbrechen" klickt
			ExitLoop
	EndSelect
WEnd
    
Exit